* The original models described in the published report employed a multilevel
* model that required the use of community level indicators for random
* effects. Given that the interviews covered such a small area (i.e,
* neighborhoods) and given the extremely sensitive of the information
* (reports on crime, gangs, threats, extortion, etc.) included in the
* questionnaire in the context of highly violent countries and regions, our
* obligation to protect the anonymity of respondents is especially high. For
* this reason, we have removed all indicators below the level of the
* municipio. Therefore, it is not possible to replicate the exact models in the
* published analysis. However, we have re-analyzed all the data using a
* simplified model (a regression without controls and without random or
* fixed effects) and find very similar results, leading to the same
* conclusions. As a courtesy to users, we provide these figures and models
* alongside the original published models for comparison.

use "Public_CARSI.dta" , clear

****Dependent Variables****

recode vicbar1a (1=100) (2=0), gen(vicbar1arr)
recode vicbar3a (1=100) (2=0), gen(vicbar3arr)
recode vicbar4a (1=100) (2=0), gen(vicbar4arr)
recode vicbar7a (1=100) (2=0), gen(vicbar7arr)

gen pese0r= int(((pese0-1)/3)*100)
gen fear4r= int(((fear4-1)/3)*100)
gen diso7r= int(((6-diso7-1)/4)*100)
gen diso8r= int(((6-diso8-1)/4)*100)
gen diso18r= int(((6-diso18-1)/4)*100)

recode fear10 (1=100) (2=0), gen(fear10r)
gen soco9r=((soco9-1)/6)*100
gen b18r=((b18-1)/6)*100

*we debated how to handle the volunteered option
*in the results shown we dropped them
recode pole2 (5=.) , gen(pole2r)
replace pole2r= int(((5-pole2r-1)/3)*100)
*however, combining 5 with 4 doesn't make substantive difference
*recode pole2 (5=4) , gen(pole2r)
*replace pole2r= int(((5-pole2r-1)/3)*100)


gen it1r= int(((5-it1-1)/3)*100)
gen pn4r= int(((5-pn4-1)/3)*100)
gen n11r=((n11-1)/6)*100



****Treated****
gen treated=treatment_group
replace treated=0 if year_code==0


****Control Variables****

*  ***Years in Neighborhood
    gen yrs_in_neighb=year - soctie2

*     *   these are errors in the data collection, so scoring as missing
        replace yrs_in_neighb=. if soctie2<1917

*     *   fieldwork dates crossed years so round up
*     *   to 0 for any negative numbers
        replace yrs_in_neighb=0 if yrs_in_neighb<0

*     *   if born in neighborhood (soctie1==1), then use age
        replace yrs_in_neighb=q2 if soctie1==1


*  ***Years of Education
    gen yrs_of_ed=yedu

*  ***Youth in Home
    gen youth_in_home=edu1
    replace youth_in_home=1 if edu1>0 & !mi(edu1)

*  ***Female
    gen female=q1-1

*  ***Age in Years
    gen age_in_yrs =q2

*  ***Household Wealth
*  ***NOTE: This variable cannot be replicated since it was originally
*  ***    calculated at the community level.  However, we provide the code
*  ***    for the way the variable was calculated (in this case at the country level).
*  ***    Of course, you may wish to estimate the quintiles at a lower level, like
*  ***    municipio, perhaps.  This the methodology is described in detail here:
*  ***    http://www.vanderbilt.edu/lapop/insights/I0806en.pdf

gen hh_wealth=.
levelsof pais, local(P)
foreach p of local P {
    levelsof year_code if pais==`p', local(Y)
    foreach y of local Y {
        pca r1 r3 r4 r4a r5 r6 r7 r8 r12 r14 r15 r16 r18 if pais==`p' & year_code==`y'
        predict scores`p'`y' if pais==`p' & year_code==`y'
        xtile HHW=scores`p'`y' if pais==`p' & year_code==`y' ,  nq(5)
        replace hh_wealth=HHW if pais==`p' & year_code==`y'
        drop scores`p'`y'
        drop HHW
        }
    }


* In the original models, random effects were included in the model for
* Country, Municipio, and Neighborhood (see note at top of document).
* The following will reproduce the results in
* "Replication Models without Identifiers.pdf"

foreach var of varlist vicbar1arr vicbar3arr vicbar4arr vicbar7arr pese0r fear4r diso7r diso8r diso18r fear10r soco9r b18r pole2r it1r pn4r n11r {
    reg `var' i.treatment_group  i.treated##i.year_code
    }




